/*
 * Decompiled with CFR 0.152.
 */
package concplus;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class GUI
extends JFrame
implements ActionListener,
ComponentListener {
    JLabel startLabel = new JLabel("start");
    JLabel endLabel = new JLabel("end");
    JLabel targetTimeLabel = new JLabel("target");
    JLabel delayLabel = new JLabel("delay");
    JLabel widenLabel = new JLabel("widen");
    JTextField inputText = new JTextField();
    JTextField startText = new JTextField();
    JTextField endText = new JTextField();
    JTextField originalStartTimeText = new JTextField();
    JTextField originalEndTimeText = new JTextField();
    JTextField targetStartTimeText = new JTextField();
    JTextField targetEndTimeText = new JTextField();
    JTextField outputText = new JTextField();
    JTextField delayText = new JTextField();
    JTextField widenText = new JTextField();
    JButton chooseFile = new JButton("input");
    JButton originalTime = new JButton("original");
    JButton calculateModification = new JButton("calculate");
    JButton writeFile = new JButton("output");
    JFileChooser fileChooser = new JFileChooser();
    File file;
    static final int xStart = 5;
    static final int xInter = 5;
    static final int yStart = 5;
    static final int yInter = 5;
    static final int h = 20;
    static final int wButton = 100;
    static final int wLabel = 50;
    static final int wAlphaText = 385;
    static final int wNumText = 135;

    public GUI() {
        this.setDefaultCloseOperation(3);
        this.setSize(510, 185);
        this.addComponentListener(this);
        this.add(this.chooseFile);
        this.add(this.inputText);
        this.add(this.startLabel);
        this.add(this.startText);
        this.add(this.endLabel);
        this.add(this.endText);
        this.add(this.originalTime);
        this.add(this.originalStartTimeText);
        this.add(this.originalEndTimeText);
        this.add(this.targetTimeLabel);
        this.add(this.targetStartTimeText);
        this.add(this.targetEndTimeText);
        this.add(this.calculateModification);
        this.add(this.delayLabel);
        this.add(this.delayText);
        this.add(this.widenLabel);
        this.add(this.widenText);
        this.add(this.writeFile);
        this.add(this.outputText);
        this.chooseFile.addActionListener(this);
        this.originalTime.addActionListener(this);
        this.calculateModification.addActionListener(this);
        this.writeFile.addActionListener(this);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String line;
        BufferedReader inFile;
        String previousLine = "";
        boolean startInt = false;
        boolean endInt = false;
        int delayInt = 0;
        double widenReal = 0.0;
        if (e.getSource() == this.chooseFile && this.fileChooser.showOpenDialog(this) == 0) {
            this.file = this.fileChooser.getSelectedFile();
            this.inputText.setText(this.file.getPath());
            this.outputText.setText(this.file.getName().substring(0, this.file.getName().length() - 3) + "srt");
        }
        if (e.getSource() == this.originalTime) {
            try {
                inFile = new BufferedReader(new FileReader(this.file));
                try {
                    while ((line = inFile.readLine()) != null) {
                        if (line.matches("[0-9]{2}:.*")) {
                            if (previousLine.equals(this.startText.getText())) {
                                this.originalStartTimeText.setText(line.substring(0, 12));
                                this.targetStartTimeText.setText(line.substring(0, 8));
                            }
                            if (previousLine.equals(this.endText.getText())) {
                                this.originalEndTimeText.setText(line.substring(0, 12));
                                this.targetEndTimeText.setText(line.substring(0, 8));
                            }
                        }
                        previousLine = line;
                    }
                }
                catch (IOException error) {
                    this.errorMessage("error reading");
                }
            }
            catch (FileNotFoundException error) {
                this.errorMessage("error opening for reading");
            }
        }
        if (e.getSource() == this.calculateModification) {
            try {
                int originalStartTime = this.time2ms(this.originalStartTimeText.getText());
                int originalEndTime = this.time2ms(this.originalEndTimeText.getText());
                int targetStartTime = this.time2ms(this.targetStartTimeText.getText());
                int targetEndTime = this.time2ms(this.targetEndTimeText.getText());
                widenReal = (double)(targetEndTime - targetStartTime) / (double)(originalEndTime - originalStartTime);
                delayInt = (int)((double)targetStartTime - widenReal * (double)originalStartTime);
                this.widenText.setText(Double.toString(widenReal).substring(0, 7));
                this.delayText.setText(Integer.toString(delayInt));
            }
            catch (NumberFormatException error) {
                this.errorMessage("error parsing");
            }
        }
        if (e.getSource() == this.writeFile) {
            if (this.widenText.getText().equals("")) {
                this.widenText.setText("1");
            }
            try {
                delayInt = Integer.parseInt(this.delayText.getText());
                widenReal = Double.parseDouble(this.widenText.getText());
                try {
                    inFile = new BufferedReader(new FileReader(this.file));
                    try {
                        PrintWriter outFile = new PrintWriter((Writer)new FileWriter(this.file.getParent() + "/" + this.outputText.getText()), true);
                        try {
                            while ((line = inFile.readLine()) != null) {
                                outFile.println(this.modified(line, delayInt, widenReal));
                            }
                        }
                        catch (IOException error) {
                            this.errorMessage("error writing");
                        }
                        outFile.close();
                    }
                    catch (IOException error) {
                        this.errorMessage("error opening for writing");
                    }
                }
                catch (FileNotFoundException error) {
                    this.errorMessage("error opening for reading");
                }
            }
            catch (NumberFormatException error) {
                this.errorMessage("error parsing");
            }
        }
    }

    String modified(String line, int delayInt, double widenReal) {
        if (line.matches("[0-9]{2}:.*")) {
            line = this.ms2time(this.processInput(line, delayInt, widenReal, 0, 12)) + " --> " + this.ms2time(this.processInput(line, delayInt, widenReal, 17, 29));
        }
        return line;
    }

    int processInput(String line, int delayInt, double widenReal, int begin, int end) {
        return (int)((double)this.time2ms(line.substring(begin, end)) * widenReal + (double)delayInt);
    }

    int time2ms(String time) {
        int ms = 3600000 * Integer.parseInt(time.substring(0, 2)) + 60000 * Integer.parseInt(time.substring(3, 5)) + 1000 * Integer.parseInt(time.substring(6, 8));
        if (time.length() == 12) {
            ms += Integer.parseInt(time.substring(9, 12));
        }
        return ms;
    }

    String ms2time(int ms) {
        DecimalFormat doubleZero = new DecimalFormat("00");
        DecimalFormat tripleZero = new DecimalFormat("000");
        int hours = ms / 3600000;
        int minutes = (ms - hours * 3600000) / 60000;
        int seconds = (ms - hours * 3600000 - minutes * 60000) / 1000;
        return doubleZero.format(hours) + ":" + doubleZero.format(minutes) + ":" + doubleZero.format(seconds) + "," + tripleZero.format(ms % 1000);
    }

    void errorMessage(String text) {
        JOptionPane.showMessageDialog(null, text);
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
        this.chooseFile.setBounds(5, 5, 100, 20);
        this.inputText.setBounds(110, 5, 385, 20);
        this.startLabel.setBounds(110, 30, 50, 20);
        this.startText.setBounds(165, 30, 135, 20);
        this.endLabel.setBounds(305, 30, 50, 20);
        this.endText.setBounds(360, 30, 135, 20);
        this.originalTime.setBounds(5, 55, 100, 20);
        this.originalStartTimeText.setBounds(165, 55, 135, 20);
        this.originalEndTimeText.setBounds(360, 55, 135, 20);
        this.targetTimeLabel.setBounds(110, 80, 50, 20);
        this.targetStartTimeText.setBounds(165, 80, 135, 20);
        this.targetEndTimeText.setBounds(360, 80, 135, 20);
        this.calculateModification.setBounds(5, 105, 100, 20);
        this.delayLabel.setBounds(110, 105, 50, 20);
        this.delayText.setBounds(165, 105, 135, 20);
        this.widenLabel.setBounds(305, 105, 50, 20);
        this.widenText.setBounds(360, 105, 135, 20);
        this.writeFile.setBounds(5, 130, 100, 20);
        this.outputText.setBounds(110, 130, 385, 20);
    }

    public void componentHidden(ComponentEvent e) {
    }
}

